//let devBuild = false;
let devBuild = true;
let developerFlagSent = false;

//import { app, BrowserWindow } from 'electron';
const { app, BrowserWindow } = require('electron');
app.allowRendererProcessReuse = true;
app.commandLine.appendSwitch ("disable-http-cache");

const path = require('path')
const os = require('os');
let thisOS = os.release();
const computerName = os.hostname();

// Handle creating/removing shortcuts on Windows when installing/uninstalling.
if (require('electron-squirrel-startup')) { // eslint-disable-line global-require
  app.quit();
}

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow = null;
makeSingleInstance();

let smallWindow = null;
let printWindow = null;

const mytoken = Math.floor(Math.random() * 100000000000);
console.log('❖ Randomized request token: '+mytoken);

const {dialog} = require('electron');
// This API can be called safely before the ready event the app module emits, it is usually used to report errors in early stage of startup.
//dialog.showErrorBox("test", "hello?");


// MENU STUFF! TODO: MOVE TO SEPARATE FILE

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and import them here.
//const {Menu, shell, dialog} = require('electron')
const {Menu, shell} = require('electron');
//const name = app.getName();
const name = app.name;

let template = [{
  label: 'Edit',
  submenu: [{
    label: 'Undo',
    accelerator: 'CmdOrCtrl+Z',
    role: 'undo'
  }, {
    label: 'Redo',
    accelerator: 'Shift+CmdOrCtrl+Z',
    role: 'redo'
  }, {
    type: 'separator'
  }, {
    label: 'Cut',
    accelerator: 'CmdOrCtrl+X',
    role: 'cut'
  }, {
    label: 'Copy',
    accelerator: 'CmdOrCtrl+C',
    role: 'copy'
  }, {
    label: 'Paste',
    accelerator: 'CmdOrCtrl+V',
    role: 'paste'
  }, {
    label: 'Select All',
    accelerator: 'CmdOrCtrl+A',
    role: 'selectall'
  }]
}, {
  label: 'View',
  submenu: [{
    label: 'Reload App Window',
    visible: false,
    accelerator: 'CmdOrCtrl+R',
    click: (item, focusedWindow) => {
      if (focusedWindow) {
        // on reload, start fresh and close any old
        // open secondary windows
        if (focusedWindow.id === 1) {
          BrowserWindow.getAllWindows().forEach(win => {
            if (win.id > 1) win.close()
          })
        }
        focusedWindow.reload()
      }
    }
  }, {
    label: 'Toggle Full Screen',
    visible: false,
    accelerator: (() => {
      if (process.platform === 'darwin') {
        return 'Ctrl+Command+F'
      } else {
        return 'F11'
      }
    })(),
    click: (item, focusedWindow) => {
      if (focusedWindow) {
        focusedWindow.setFullScreen(!focusedWindow.isFullScreen())
      }
    }
  }, {
    label: 'Toggle Developer Tools',
  //visible: devBuild,
    accelerator: (() => {
      if (process.platform === 'darwin') {
        return 'Alt+Command+I'
      } else {
        return 'Ctrl+Shift+I'
      }
    })(),
    click: (item, focusedWindow) => {
      if (focusedWindow) {
        //focusedWindow.toggleDevTools({mode:'undocked'})
        //mainWindow.toggleDevTools({mode:'undocked'})
        mainWindow.webContents.openDevTools({mode:'undocked'})
      }
    }
  }, {
    type: 'separator',
    visible: false
  }, {
    label: 'App Menu Demo',
    visible: false,
    click: function (item, focusedWindow) {
      if (focusedWindow) {
        const nativeImage = require('electron').nativeImage
        let image = nativeImage.createFromPath(`${__dirname}/AlertInfoIcon.png`);

        // let arguments = process.argv.slice(2);
        // arguments.forEach(function(val,index, array) {
        //   console.log(index + ': ' + val);
        // });

        const options = {
          type: 'info',
          icon: image,
          title: 'Application Menu Demo',
          buttons: ['Neat', 'Still Neat'],
          //message: 'This demo is for the Menu section, showing how to create a clickable menu item in the application menu.'
          message: process.argv.toString().split(',')[1]
        }
        dialog.showMessageBox(focusedWindow, options, function () {})
      }
    }
  }]
}, {
  label: 'Window',
  role: 'window',
  submenu: [{
    label: 'Minimize',
    accelerator: 'CmdOrCtrl+M',
    role: 'minimize'
  }, {
    label: 'Close',
    accelerator: 'CmdOrCtrl+W',
    role: 'close'
  }, {
    type: 'separator'
  }, {
    label: 'Reopen Window',
    accelerator: 'CmdOrCtrl+Shift+T',
    enabled: false,
    key: 'reopenMenuItem',
    click: () => {
      app.emit('activate')
    }
  }]
}, {
  label: 'Help',
  role: 'help',
  submenu: [{
    label: 'Learn More',
    click: () => {
      shell.openExternal('http://cni-boston.org')
    }
  },{
    type: 'separator'
  },{
    label: `About ${name}`,
    // role: 'about'
    click: (item, focusedWindow) => {
      if (smallWindow === null) {
        createSmallWindow()
      } else {
          smallWindow.focus()
          smallWindow.flashFrame(true)
        }
      }
  }]
}]

function addUpdateMenuItems (items, position) {
  if (process.mas) return

  const version = app.getVersion()
  let updateItems = [{
    label: `Version ${version}`,
    enabled: false
  }, {
    label: 'Checking for Update',
    enabled: false,
    key: 'checkingForUpdate'
  }, {
    label: 'Check for Update',
    visible: false,
    key: 'checkForUpdate',
    click: () => {
      require('electron').autoUpdater.checkForUpdates()
    }
  }, {
    label: 'Restart and Install Update',
    enabled: true,
    visible: false,
    key: 'restartToUpdate',
    click: () => {
      require('electron').autoUpdater.quitAndInstall()
    }
  }]

  items.splice.apply(items, [position, 0].concat(updateItems))
}

function doTheThingIWant(myVar) {

  const menu = Menu.getApplicationMenu()
  let flags = "?token="+mytoken+"&version="+app.getVersion()+"&client="+computerName;

  // reset all disabled and checked menu items in App menu
  menu.items[0].submenu.items.forEach(item => {
        item.enabled = true
        item.checked = false
      })

  if(myVar == 'cni29'){

    mainWindow.loadURL("https://cni29.bwh.harvard.edu/d2/whereto.php"+flags);
    //mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/zz-2020-02-06/concord/'+flags)
    menu.items[0].submenu.items[6].checked = true
    menu.items[0].submenu.items[6].enabled = false
  }

  if(myVar == 'msapps'){
    //mainWindow.loadURL('https://msapps.org/8cbb1fb0-85be-4f94-ab7b-b751f81aab4d/')
    mainWindow.loadURL("https://cni-boston.org/backup/whereto.php"+flags);
    menu.items[0].submenu.items[7].checked = true
    menu.items[0].submenu.items[7].enabled = false
  }

  if(myVar == 'ansibler'){
    if(computerName == "ansibler.local"){
      mainWindow.loadURL('https://ansibler.local/concord/'+flags);
    } else if(computerName == "ansibler.partners.org" || computerName == "klopedia.partners.org"){
      mainWindow.loadURL('https://ansibler.partners.org/concord/'+flags);
    } else if(computerName == "klopedia.local"){
      mainWindow.loadURL('https://home.io:617/concord/'+flags);
    } else {
      mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/denied.html')
    }

    //mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/whereto.php?token='+mytoken+"&version="+app.getVersion());
    //mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/zz-5/concord/interface.html')

    //mainWindow.loadURL('https://home.io:617/concord/interface.html');
    //mainWindow.loadURL('https://10.0.0.11/concord/interface.html');  

    //mainWindow.loadURL('https://ansibler.local/concord/whereto.php?token='+mytoken+"&version="+app.getVersion());
    //mainWindow.loadURL('https://ansibler.local/concord/newer.html');
    //mainWindow.loadURL('https://ansibler.local/concord/nope.html');
    //mainWindow.loadURL('https://ansibler.partners.org/concord/interface.html');
    //mainWindow.loadURL('https://ansibler.local/concord/blank.html');
    menu.items[0].submenu.items[9].checked = true
    menu.items[0].submenu.items[9].enabled = false
  }

  if(myVar == 'ansibler-internal'){
    mainWindow.loadURL('https://ansibler.partners.org/concord/');
    menu.items[0].submenu.items[9].checked = true
    menu.items[0].submenu.items[9].enabled = false
  }
  
  if(myVar == 'localhost'){
    mainWindow.loadURL('https://localhost/concord/'+flags)
    menu.items[0].submenu.items[10].checked = true
    menu.items[0].submenu.items[10].enabled = false
  }

  if(myVar == 'custom'){
    mainWindow.loadURL("https://cni29.bwh.harvard.edu/d2/staging/concord/index.php"+flags);
    menu.items[0].submenu.items[11].checked = true
    menu.items[0].submenu.items[11].enabled = false
  }

}

function findReopenMenuItem () {
  const menu = Menu.getApplicationMenu()
  if (!menu) return

  let reopenMenuItem
  menu.items.forEach(item => {
    if (item.submenu) {
      item.submenu.items.forEach(item => {
        if (item.key === 'reopenMenuItem') {
          reopenMenuItem = item
        }
      })
    }
  })
  return reopenMenuItem
}

if (process.platform === 'darwin') {
  //const name = app.getName()
  //template.push({
  template.unshift({
    label: name,
    submenu: [{
      label: `About ${name}`,
      // role: 'about'
      click: (item, focusedWindow) => {
        if (smallWindow === null) {
          createSmallWindow()
        } else {
            smallWindow.focus()
            smallWindow.flashFrame(true)
          }
        }
    }, {
      type: 'separator'
    }, {
      label: 'Services',
      role: 'services',
      submenu: []
    }, {
      type: 'separator'
    }, {
      label: `🛑 Reset ${name}`,
      accelerator: 'CmdOrCtrl+Shift+R',
      click: (item, focusedWindow) => {
          //mainWindow.reload()
          const menu = Menu.getApplicationMenu();
          menu.items[0].submenu.items[9].checked = false;
          menu.items[0].submenu.items[9].enabled = true;
          let flags = "?token="+mytoken+"&version="+app.getVersion()+"&client="+computerName;
          mainWindow.loadURL("https://cni29.bwh.harvard.edu/d2/whereto.php"+flags);
          //mainWindow.loadURL(`file://${__dirname}/start.html`+flags);
          mainWindow.setSize(1024, 768, true);
          }
    }, {
      type: 'separator'
    }, {
      label: `🌐 Use Server ${name} from cni29`,
      type: 'checkbox',
      checked: true,
      enabled: false,
      visible: devBuild,
      click: (item, focusedWindow) => {
          doTheThingIWant("cni29");
          }
    }, {
      //label: `🌐 Use Server ${name} from MSApps.org`,
      label: `🌐 Use Server ${name} from msApps`,
      key: 'msapps',
      type: 'checkbox',
      visible: devBuild,
      click: (item, focusedWindow) => {
          doTheThingIWant("msapps");
          }
    }, {
      type: 'separator',
      visible: devBuild,
    }, {
      label: `💟 Use Developer ${name} from ansibler`,
      type: 'checkbox',
      visible: devBuild,
      // checked: true,
      // enabled: false,
      click: (item, focusedWindow) => {
          doTheThingIWant("ansibler")
          }
    }, {
      label: `⚛️ Use Developer ${name} from localhost`,
      type: 'checkbox',
      visible: devBuild,
      click: (item, focusedWindow) => {
        doTheThingIWant("localhost")
          }
    }, {
      label: `⚠️ Use Staging ${name}`,
      type: 'checkbox',
      visible: devBuild,
      click: (item, focusedWindow) => {
          doTheThingIWant("custom")
          }
    }, {
      type: 'separator'
    }, {
      label: `Hide ${name}`,
      accelerator: 'Command+H',
      role: 'hide'
    }, {
      label: 'Hide Others',
      accelerator: 'Command+Alt+H',
      role: 'hideothers'
    }, {
      label: 'Show All',
      role: 'unhide'
    }, {
      type: 'separator'
    }, {
      label: 'Quit',
      accelerator: 'Command+Q',
      click: () => {
        app.quit()
      }
    }]
  })

  // Window menu.
  template[3].submenu.push({
    type: 'separator'
  }, {
    label: 'Bring All to Front',
    role: 'front'
  })

  //addUpdateMenuItems(template[0].submenu, 1)
}

// app menu test for windows
if (process.platform === 'win32') {

template.unshift({
  label: `Application`,
  submenu: [{
    label: `About ${name}`,
    // role: 'about'
    click: (item, focusedWindow) => {
      if (smallWindow === null) {
        createSmallWindow()
      } else {
          smallWindow.focus()
          smallWindow.flashFrame(true)
        }
      }
  }, {
    type: 'separator'
  }, {
    label: `☇ Reset ${name}`,
    accelerator: 'CmdOrCtrl+Shift+R',
    click: (item, focusedWindow) => {
        //mainWindow.reload()
        mainWindow.loadURL(`file://${__dirname}/start.html`);
        }
  }, {
    type: 'separator'
  }, {
    label: `☁︎ Use Server ${name} from cni29`,
    type: 'checkbox',
    checked: true,
    enabled: false,
    click: (item, focusedWindow) => {
        doTheThingIWant("cni29");
        }
  }, {
    label: `☁︎ Use Server ${name} from msApps`,
    key: 'msapps',
    type: 'checkbox',
    click: (item, focusedWindow) => {
        doTheThingIWant("msapps");
        }
  }, {
    type: 'separator'
  }, {
    label: `✦ Use Developer ${name} from ansibler`,
    type: 'checkbox',
    // checked: true,
    // enabled: false,
    click: (item, focusedWindow) => {
        doTheThingIWant("ansibler")
        }
  }, {
    label: `⚛︎ Use Developer ${name} from localhost`,
    type: 'checkbox',
    click: (item, focusedWindow) => {
      doTheThingIWant("localhost")
        }
  }, {
    label: `⚠ Use Staging ${name}`,
    type: 'checkbox',
    click: (item, focusedWindow) => {
        doTheThingIWant("custom")
        }
  }, {
    type: 'separator'
  }, {
    label: `Hide ${name}`,
    accelerator: 'Command+H',
    role: 'hide'
  }, {
    label: 'Hide Others',
    accelerator: 'Command+Alt+H',
    role: 'hideothers'
  }, {
    label: 'Show All',
    role: 'unhide'
  }, {
    type: 'separator'
  }, {
    label: 'Quit',
    accelerator: 'Command+Q',
    click: () => {
      app.quit()
    }
  }]
})

}


if (process.platform === 'win32') {
  const helpMenu = template[template.length - 1].submenu
  addUpdateMenuItems(helpMenu, 0)
}

// END MENU STUFF.




const createWindow = () => {
  // Create the browser window.
  mainWindow = new BrowserWindow({
    //title: app.getName(),
    title: app.name,
      width: 1024,
      height: 768,
      resizable: false,
      maximizable: false,
      zoomToPageWidth: false,
      fullscreenable: false,
      fullscreenWindowTitle: false,
      //autoHideMenuBar: false,
      autoHideMenuBar: true,
      tabbingIdentifier: 'concord',
      backgroundColor: '#2E2E2E',
      //backgroundColor: '#FFB6C1',
      //  transparent: true,
       // appearance-based, light, dark, titlebar, selection, menu, popover, sidebar, medium-light or ultra-dark.
       // Please note that using frame: false in combination with a vibrancy value requires that you use a non-default titleBarStyle
      //vibrancy: 'appearance-based',
      //frame: false,
      // frame: true,
      // thickFrame: true,
      titleBarStyle: 'hiddenInset',
      // titleBarStyle: 'hidden',
      webPreferences: {
        // plugins: false,
	      // experimentalFeatures: false,
        nodeIntegration: true,
        devTools: true,
        webSecurity: true,
        allowRunningInsecureContent: false,
        enableRemoteModule: false,
        textAreasAreResizable: false,
        scrollBounce: true,
        safeDialogs: true,
        safeDialogsMessage: '???'
      }
  });

  // and load the index.html of the app.
  //mainWindow.loadURL(`file://${__dirname}/print.pdf`)
  //mainWindow.loadURL(path.join('file://', __dirname, '/index.html'))

  console.log('❖ Machine Name: '+computerName); //✔︎
  //console.log('\u001b[0;32m color test \u001b[0m');
  //console.log('• Versions: '+JSON.stringify(process.versions));


  const optionsZ = {
    type: 'warning',
    title: '',
    buttons: ['OK'],
    message: "This application has been built for macOS Mojave (10.14).",
    detail: "You are running an earlier version of macOS, with which this application has not been tested.\n\nPlease upgrade to the latest release of macOS for the best user experience."
  }
    
  if(thisOS.split(".")[0] < 18){
    //dialog.showMessageBox(mainWindow, optionsZ, function () {})
    }

  const { systemPreferences } = require('electron');
  const { nativeTheme } = require('electron');
  //if (process.platform == 'darwin') {console.log('• Dark Mode: '+systemPreferences.isDarkMode());}
  if (process.platform == 'darwin') {console.log('❖ Dark Mode: '+nativeTheme.shouldUseDarkColors);}
  if (process.platform == 'win32')  {console.log('❖ Aero Glass: '+systemPreferences.isAeroGlassEnabled());}
  //console.log("\007");
  //shell.beep();

  let flags = "?token="+mytoken+"&version="+app.getVersion()+"&client="+computerName;

  if(process.argv.toString().split(',')[1] == "--dev"){
      console.log("• Developer Mode activated!");
      developerFlagSent = true;
      //doTheThingIWant('ansibler-internal');
      //mainWindow.webContents.executeJavaScript("isUncompiled();");
  }

    if(!app.isPackaged && computerName.includes("ansibler")){
    
      doTheThingIWant("ansibler");
      //mainWindow.loadURL(`https://localhost/concord/`+flags);

      } else {
        //mainWindow.loadURL(`file://${__dirname}/start.html`+flags);
        mainWindow.loadURL("https://cni29.bwh.harvard.edu/d2/whereto.php"+flags);
        }
      

    // if(computerName == "ansibler.local"){
    //   //mainWindow.loadURL('https://ansibler.local/concord/'+flags);
    //   mainWindow.loadURL(`file://${__dirname}/start.html`);
    // } else if(computerName == "ansibler.partners.org" || computerName == "klopedia.partners.org"){
    //   mainWindow.loadURL('https://ansibler.partners.org/concord/'+flags);
    // } else if(computerName == "klopedia.local"){
    //   mainWindow.loadURL('https://home.io:617/concord/'+flags);
    // } else {
    //   mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/denied.html')
    // }




    // if(computerName.includes("ansibler")){
    //   doTheThingIWant('ansibler');
    //   } else {
    //     doTheThingIWant('cni29');
    //     }
    //   }

  // Open the DevTools.
  //mainWindow.webContents.openDevTools({detach: true});
  //mainWindow.webContents.openDevTools({mode:'undocked'});

  mainWindow.webContents.on('did-navigate', (event, url, httpResponseCode, httpStatusText) => {

    const options = {
      type: 'warning',
      title: '',
      buttons: ['Oh No'],
      message: "Could not load the selected Concord distribution.",
      detail: "The server was not able to locate the proper directory."
      //detail: url
    }

    const optionsX = {
      type: 'warning',
      title: 'Application Menu Demo',
      buttons: ['Oh No'],
      message: "You do not have a Concord distribution in your local Apache documents folder."
      //detail: "The server was not able to locate the proper directory."
    }

    if(httpResponseCode != 200){
      mainWindow.loadURL(path.join('file://', __dirname, '/blank.html'))
      
      if(url == "https://localhost/concord/interface.html"){
        dialog.showMessageBox(mainWindow, optionsX, function () {})
      } else {
        dialog.showMessageBox(mainWindow, options, function () {}) 
        }
      //mainWindow.loadURL('data:text/html;charset=utf-8,<YOUR HTML/>');
      }

      
  
  });

  let allowClose = false;
  mainWindow.on('close', (event) => {
   
    //return;
    //console.log(allowClose);
    //if(!allowClose){event.preventDefault();} else {return;}
    if(mainWindow.isDocumentEdited()){event.preventDefault();} else {return;}

    const options = {
      type: 'info',
      title: 'Application Menu Demo',
      buttons: ['Save and Close', 'Cancel', 'Don\'t Save'],
      message: 'There are unsaved records. Save before closing?'
      //app.isInApplicationsFolder().toString()
    }
  
    dialog.showMessageBox(mainWindow, options, (response) => {
      
      switch(response)
      {
          case 0:
              console.log("save");
              return;
          case 1:
              console.log("cancel");    
              return;
          case 2:
              console.log("don't save");
              allowClose = true;
              mainWindow.destroy();
              return true;

      }

    });   

  });

  // Emitted when the window is closed.
  mainWindow.on('closed', () => {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    mainWindow = null;
  });
};

const createSmallWindow = () => {
  // Create the small browser window.
  smallWindow = new BrowserWindow({
      title: "",
      show: false,
      width: 580,
      height: 325,
      //1384x874
      // width: 692,
      // height: 600,
      // parent: mainWindow,
      // modal: true,
      resizable: false,
      maximizable: false,
      minimizable: false,
      skipTaskbar: true,
      backgroundColor: '#272727',
      // frame: false,
      // transparent: true,
      autoHideMenuBar: true,
      titleBarStyle: 'hiddenInset',
      webPreferences: {
	      experimentalFeatures: false,
        nodeIntegration: true,
        devTools: true,
        webSecurity: false,
        allowRunningInsecureContent: true,
        scrollBounce: false,
        safeDialogs: false
      }
  });

  //mainWindow.addTabbedWindow(smallWindow);

  // and load the index.html of the app.
  //mainWindow.loadURL(`file://${__dirname}/index.html`)
  smallWindow.loadURL(path.join('file://', __dirname, '/about.html'))

  smallWindow.once('ready-to-show', () => {
    smallWindow.show()
  })

  // Emitted when the window is closed.
  smallWindow.on('closed', () => {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    smallWindow = null;
  });
};




const createPrintWindow = () => {
  // Create the small browser window.
  printWindow = new BrowserWindow({
      title: "",
      show: true,
      x: 2000,
      y: 0,
      width: 600,
      // minWidth: 1024,
      maxWidth: 1024,
      height: 480,
      minHeight: 480,
      // parent: mainWindow,
      // modal: true,
      resizable: true,
      maximizable: false,
      minimizable: false,
      backgroundColor: '#272727',
      webPreferences: {
	      experimentalFeatures: false,
        nodeIntegration: true,
        devTools: true,
        webSecurity: false,
        allowRunningInsecureContent: true,
        scrollBounce: false,
        safeDialogs: false
      }
  });

  //printWindow.loadURL('file://' + __dirname + '/commbadge.html?foo=bar&title=title&description=descriptions%20are%20awesome&details=details');
  //printWindow.loadURL('https://msapp.org/concord/apps/study-screening/');
  printWindow.loadURL('https://ansibler.partners.org/concord/apps/study-screening/');

  printWindow.once('ready-to-show', () => {
    printWindow.show();
    //printWindow.webContents.executeJavaScript("document.getElementById('json').innerText = 'Show Variables!';");
  })

  // Emitted when the window is closed.
  printWindow.on('closed', () => {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    printWindow = null;
  });
};


app.on('browser-window-blur', () => {
  //console.log('Window inactive!');
})

app.on('browser-window-focus', () => {
  //console.log('Window active!');
})

// Quit when all windows are closed.
app.on('window-all-closed', () => {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  //if (process.platform !== 'darwin') {
    app.quit();
  //}
});

app.on('activate', () => {
  // On OS X it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (mainWindow === null) {
    createWindow();
  }
});

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
//app.on('ready', createWindow);

app.on('ready', () => {
  const menu = Menu.buildFromTemplate(template)
  Menu.setApplicationMenu(menu)

  // if(computerName == "ansibler.local" || computerName == "ansibler.partners.org" ){
  //     let menu = Menu.getApplicationMenu();
  //     menu.items[0].submenu.items[6].checked = false;
  //     menu.items[0].submenu.items[6].enabled = true;
  //     menu.items[0].submenu.items[9].checked = true;
  //     menu.items[0].submenu.items[9].enabled = false;
  //     }

      createWindow(); // do this AFTER menu already built, or we won't be able to modify it

//  app.getAppPath()
// app.isPackaged.toString()
// app.dock.bounce([critical, informational is default])
//Returns Integer an ID representing the request.
//app.dock.cancelBounce(id)
if (process.platform == 'darwin') {
if(!app.isInApplicationsFolder() && app.isPackaged){
  return;
  //console.warn("NOT IN APPS FOLDER!");

  const nativeImage = require('electron').nativeImage
  //let image = nativeImage.createFromPath('/tmp/AlertInfoIcon.png')
  //let image = nativeImage.createFromPath('/tmp/AlertStopIcon.png')
  //let image = nativeImage.createFromPath('/tmp/AlertCautionIcon.png')
  //let image = nativeImage.createFromPath('/tmp/AlertNoteIcon.png')
  let image = nativeImage.createFromPath(`${__dirname}/AlertQuestionIcon.png`);
  
  const options = {
    type: 'question',
    title: '',
    buttons: [`Don't Move`, `Yes Please`],
    defaultId: 1,
    icon: image,
    message: `Would you like to move "Concord" to the Applications folder, where your other apps are stored?`
    //app.isInApplicationsFolder().toString()
  }
  dialog.showMessageBox(mainWindow, options, (response) => {
      
    switch(response)
    {
        case 0:
            console.log("cancel");    
            return false;
        case 1:
            console.log("move app");
            let wasMoveSuccessful = app.moveToApplicationsFolder();
            console.log("move result: "+wasMoveSuccessful);
            if(wasMoveSuccessful){mainWindow.destroy();}
            return true;

    }

  });

  }

if(!app.isPackaged){
  // commands here are only for developer version starting from terminal
  }

}

})

// app.on('before-quit', (event) => {
  
//   const options = {
//     type: 'info',
//     title: 'Application Menu Demo',
//     buttons: ['Oh Damn'],
//     message: 'About to quit...'
//     //app.isInApplicationsFolder().toString()
//   }

//   dialog.showMessageBox(mainWindow, options, function () {  event.preventDefault();
//   })

// })

app.on('browser-window-created', () => {
  let reopenMenuItem = findReopenMenuItem()
  if (reopenMenuItem) reopenMenuItem.checked = true
})

app.on('window-all-closed', () => {
  let reopenMenuItem = findReopenMenuItem()
  if (reopenMenuItem) reopenMenuItem.enabled = true
})

let naughtyCertificate;
// SSL/TSL: this is the self-signed certificate support
app.on('certificate-error', (event, webContents, url, error, certificate, callback) => {

  //console.log(naughtyCertificate);
  naughtyCertificate = certificate;
  //console.log(naughtyCertificate);

  //let certResponse = dialog.showCertificateTrustDialog(mainWindow, {certificate, message: "Do you trust the security certificate from the domain bwh.harvard.edu?"},() => {});

  // On certificate error we disable default behaviour (stop loading the page)
  // and we then say "it is all fine - true" to the callback
  // const options = {
  //   type: 'info',
  //   title: 'Application Menu Demo',
  //   buttons: ['Oh Damn'],
  //   message: error
  // }
  // dialog.showMessageBox(mainWindow, options, function () {})
  //if (url === 'https://github.com') {
    event.preventDefault();
    callback(true);
    //}

});

const {ipcMain} = require('electron')

ipcMain.on('print-me-please', (event, arg) => {

  //let thePrinters = mainWindow.webContents.getPrinters();
  //console.log(thePrinters);
  //console.log("literally anything");
  //mainWindow.webContents.print({silent: true, deviceName: 'PDFwriter'});
  //mainWindow.webContents.print({silent: false});
  // mainWindow.webContents.print({silent: false}, (success) => {
  //   console.log("Did it work: "+success);
  // });
  // console.log("what just happened");

  //mainWindow.webContents.print({options: {copies: '2'}, silent: true, printBackground: true, deviceName: 'PDFwriter'});

  var pageSettingsSilent = {
    // Can be default, none, printableArea, or custom. If custom is chosen, you will also need to specify top, bottom, left, and right
    'marginsType': {'marginType': 'none'},
    'color': false,
    //'landscape': false,
    'printBackground': true, 
    // 'pagesPerSheet': 2,
    // 'pageRanges': {'from': 1, 'to': 3},
    // 'duplexMode': 'simplex',
          // or shortEdge, or longEdge
    'copies': 2,
    'silent': true,
    //'deviceName': 'PDFwriter'
  }

//   const options = { silent: true, deviceName: 'My-Printer' }
// win.webContents.print(options, (success, errorType) => {
//   if (!success) console.log(errorType)
// })
  mainWindow.webContents.print(pageSettingsSilent, (success, errorType) => {
    //if (!success) console.log(errorType)
    console.log("Did it work: "+success);
    console.log("printing complete");
    //printWindow.webContents.executeJavaScript("electronSaidItPrinted();");
    //mainWindow.webContents.executeJavaScript("electronSaidItPrintedToMainWindow();");
    //if (error) throw error;
  });
  return;

  printWindow.webContents.print(pageSettingsSilent, (success) => {
    console.log("Did it work: "+success);
    console.log("printing complete");
    printWindow.webContents.executeJavaScript("electronSaidItPrinted();");
    mainWindow.webContents.executeJavaScript("electronSaidItPrintedToMainWindow();");
    //if (error) throw error;
})
  
  // Use default printing options
  // const fs = require('fs')
  // mainWindow.webContents.printToPDF({silent: false, printBackground: false, landscape: true, marginsType: 2}, (error, data) => {
  //   if (error) throw error
  //   fs.writeFile('/tmp/print.pdf', data, (error) => {
  //     if (error) throw error
  //     console.log('PDF saved successfully.')
  //    exec(`lpr ${filePath}`, () => fs.unlink(filePath));
  //   })
  // })

})

let hotPotato = null;
ipcMain.on('inject-print-helper', (event, arg) => {
  //printWindow.webContents.openDevTools();
  //printWindow.webContents.executeJavaScript("document.getElementById('json-dump').innerHTML = 'Patient data!';");
  //printWindow.webContents.executeJavaScript("document.getElementById('json-dump').innerHTML = '"+JSON.stringify(arg)+"';");
  printWindow.webContents.executeJavaScript("document.getElementById('json_all').innerHTML = '"+JSON.stringify(hotPotato)+"';");
})

ipcMain.on('start-print-helper', (event, arg) => {
  hotPotato = arg;
  
  if (printWindow === null) {
    createPrintWindow()
  } else {
    printWindow.focus()
    }
  })

ipcMain.on('show-about-please', (event, arg) => {
  if (smallWindow === null) {
    createSmallWindow()
  } else {
      smallWindow.focus()
      smallWindow.flashFrame(true)
    }
  })

ipcMain.on('whisper-packaged-state', (event, arg) => {
  if(!app.isPackaged || computerName.includes("klopedia") || developerFlagSent){
  mainWindow.webContents.executeJavaScript("isUncompiled(true);");} else {
  mainWindow.webContents.executeJavaScript("isUncompiled(false);");}
  })

ipcMain.on('beep-please', (event, arg) => {
  shell.beep();
  })


ipcMain.on('show-cert-please', (event, arg) => {
  //console.log(naughtyCertificate);
  //console.log(typeof naughtyCertificate);
  //return;
  dialog.showCertificateTrustDialog(mainWindow, {certificate: naughtyCertificate, message: "Your connection to the MS Database is encrypted with a trusted certificate from 'bwh.harvard.edu'."},() => {});
})


ipcMain.on('launch-classic-forms', (event, arg) => {
      var child = require('child_process').exec //note: exec spawns shell by default; exefile does not
        //var executablePath = "/Applications/Firefox 52 ESR.app/Contents/MacOS/Firefox";
        //var executablePath = "open '/Applications/Firefox 52 ESR.app'";// --args -ProfileManager";
        var executablePath = "open '/Applications/Concord.app/Contents/Embedded/Classic MS Database.app'";// --args -ProfileManager";
        let executableFlags = "";//["-ProfileManager"];
        //const child = execFile('node', ['--version'], (error, stdout, stderr) => {

    child(executablePath, executableFlags, function(err, data) {
        if(err){
          console.error(err);
          return;
        }
    
        console.log(data.toString());
    }); 
})

ipcMain.on('fix-java-settings', (event, arg) => {
  var child = require('child_process').exec //note: exec spawns shell by default; exefile does not
    //var executablePath = "/Applications/Firefox 52 ESR.app/Contents/MacOS/Firefox";
    //var executablePath = "open '/Applications/Firefox 52 ESR.app'";// --args -ProfileManager";
    var executablePath = "open '/Applications/Concord.app/Contents/Embedded/Fix Java Settings.app'";// --args -ProfileManager";
    let executableFlags = "";//["-ProfileManager"];
    //const child = execFile('node', ['--version'], (error, stdout, stderr) => {

child(executablePath, executableFlags, function(err, data) {
    if(err){
      console.error(err);
      return;
    }

    console.log(data.toString());
}); 
})

ipcMain.on('make-me-dirty-please', (event, arg) => {
  mainWindow.setDocumentEdited(true);
})

ipcMain.on('make-me-clean-please', (event, arg) => {
  mainWindow.setDocumentEdited(false);
})

ipcMain.on('close-me-please', (event, arg) => {
  mainWindow.close()
})

ipcMain.on('zoom-me-please', (event, arg) => {
  mainWindow.maximize()
})

ipcMain.on('mini-me-please', (event, arg) => {
  mainWindow.minimize()
})

ipcMain.on('update-badge', (event, arg) => {
  app.setBadgeCount(arg);
})

ipcMain.on('resize-me-please', (event, arg) => {
  //console.log(mainWindow.getSize()[0]);
  if(mainWindow.getSize()[0] != 1280){
    mainWindow.setSize(1280, 768, true);
    let newLeft = mainWindow.getPosition()[0];
    if(newLeft > -1){
      newLeft = newLeft - 256;
      if(newLeft < 0){newLeft = 0;}}
    mainWindow.setPosition(newLeft, mainWindow.getPosition()[1], true);
    // mainWindow.center();
  } else {
    mainWindow.setSize(1024, 768, true);
    }

})

ipcMain.on('reset-me-please', (event, arg) => {
  // const options = {
  //   type: 'info',
  //   title: 'Application Menu Demo',
  //   buttons: ['Let\'s Do This!'],
  //   message: 'Concord will now reset.'
  // }
  // dialog.showMessageBox(mainWindow, options, function () {mainWindow.reload()})
  mainWindow.reload()
})

// process.on("uncaughtException", (err) => {
//   const messageBoxOptions = {
//        type: "error",
//        title: "Error in Main process",
//        message: "Something failed"
//    };
//    dialog.showMessageBox(messageBoxOptions);
//    throw err;
// });

// win.loadURL('http://localhost:8000/post', {
//   postData: [{
//     type: 'rawData',
//     bytes: Buffer.from('hello=world')
//   }],
//   extraHeaders: 'Content-Type: application/x-www-form-urlencoded'
// })

//win.setContentProtection(enable)??







// Make this app a single instance app.
//
// The main window will be restored and focused instead of a second window
// opened when a person attempts to launch a second instance.
//
// Returns true if the current version of the app should quit instead of
// launching.
function makeSingleInstance () {
  
  //if (process.mas) return

  const gotTheLock = app.requestSingleInstanceLock();
  console.log('❖ Instance Lock Requested! Success: '+gotTheLock);

  if (!gotTheLock) {
    app.quit()
  } else {

  app.on('second-instance', () => {
    console.log('❖ SECOND INSTANCE DETECTED!');
    if (mainWindow) {
      if (mainWindow.isMinimized()) mainWindow.restore()
      mainWindow.focus()
    }
  })
}
}

//const glob = require('glob');
//loadParts();

//let myThing = require(path.join(__dirname, 'parts/menus.js'));
//console.log(randomValue);

// Require each JS file in the main-process dir
function loadParts () {
  const files = glob.sync(path.join(__dirname, 'parts/*.js'))
  files.forEach((file) => { require(file) })
}